<?php $__env->startSection('title'); ?>
    Headline
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="https://powerworkerearn.com/assets/css/flipdown.css">
    
<style>
    .table th {
        background-color: rgba(250, 250, 250, 1); /* White faded background */
        color: #000066; /* Black font color */
        font-size: 12px;
    }
/* Remove vertical borders for table cells and adjust horizontal border color */
    .table-no-vertical-border th,
    .table-no-vertical-border td {
        border-left: none;  /* Remove left border */
        border-right: none; /* Remove right border */
        border-color: rgba(0, 0, 0, 0.1); /* Adjust the border color (0.1 for a very faint line) */
    }
    .table td {
        font-size: 14px;
        color: #000;
    }
    .rotor-bottom, .rotor, .rotor-leaf-front, .rotor-leaf-rear, .rotor-top {
    background-color: green !important;
  }
    
    .countdown {
            text-transform: uppercase;
            font-weight: bold;
        }
        
        .countdown span {
            text-shadow: 1px 1px 3px rgba(0, 0, 0, 0.1);
            font-size: 3rem;
            margin-left: 0.8rem;
        }
        
        .countdown span:first-of-type {
            margin-left: 0;
        }
        
        .countdown-circles {
            text-transform: uppercase;
            font-weight: bold;
        }
        
        .countdown-circles span {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 2px 2px 10px rgba(0, 0, 0, 0.1);
        }
        
        .countdown-circles span:first-of-type {
            margin-left: 0;
        }
        
        .bg-gradient-4 {
            /*background: #007991;*/
            /*background: -webkit-linear-gradient(to right, #007991, #78ffd6);*/
            /*background: linear-gradient(to right, #007991, #78ffd6);*/
            padding: 5px;
        }
        
        .rounded {
            border-radius: 1rem !important;
        }
        
        .btn-demo {
            padding: 0.5rem 2rem !important;
            border-radius: 30rem !important;
            background: rgba(255, 255, 255, 0.3);
            text-transform: uppercase;
            font-weight: bold !important;
        }
        
        .btn-demo:hover, .btn-demo:focus {
            background: rgba(255, 255, 255, 0.5);
        }
        
        .l-date{
            background-color: green !important;
            color: #fff;
            padding: 0px 13px;
            border-radius: 10px;
            margin-left: 2px !important;
        }
        .l-date-text{
            color: #000;
            font-size: 15px !important;
            line-height: 10px !important;
            margin-left: 2px !important;
        }
        
        @media  screen and (max-width: 767px) {
            .l-date{
                font-size: 35px !important;
                padding: 0px 6px;
                border-radius: 5px;
            }
            
            .l-date-text{
                font-size: 10px !important;
            }
        }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('back-content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0 text-dark">Top 15 Job Poster</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
                        <li class="breadcrumb-item active">All Headline</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-7 col-7">
                    <div class="card card-success">
                        <div class="card-header">
                            <h3 class="card-title">All Headline</h3>
                        </div>
                        <div class="card-body">
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th width="5%">#</th>
                                        <th>Title</th>
                                        <th width="10%">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $headlines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $headline): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($key + 1); ?></td>
                                            <td><?php echo e($headline->title); ?></td>
                                            <td>
                                                <button  type="button" onclick="deleteData(<?php echo e($headline->id); ?>)" class="btn btn-danger btn-sm">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                                <form id="delete-form-<?php echo e($headline->id); ?>" action="<?php echo e(route('admin.withdraw-headline.delete', $headline->id)); ?>" method="POST" style="display: none;">
                                                    <?php echo csrf_field(); ?>
                                                </form>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="col-lg-5 col-5">
                    <form action="<?php echo e(route('admin.withdraw-headline.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="card card-primary">
                            <div class="card-header">
                                <h3 class="card-title">New headline</h3>
                            </div>
                            <div class="card-body row">
                                <div class="form-group col-lg-12 col-md-12 col-12">
                                    <label for="title">Title</label>
                                    <textarea class="form-control" name="title" id="title" cols="30" rows="4" required></textarea>
                                </div>

                                <div class="form-group col-lg-12 col-md-12 col-12">
                                    <label for="headline_link">Link</label>
                                    <input type="text" class="form-control" id="headline_link" name="link" value="#" placeholder="Link">
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
                
                <div class="row justify-content-center">
                  <div class="col-lg-10">
                    
                      <div class="">
                        <div class="text-center">
                          <div id="flipdownTimer" class="flipdown d-inline-block"></div>
                        </div>
                        <h6>
                          <script>
                            document.addEventListener('DOMContentLoaded', () => {
                              function calculateEndOfMonthTimestamp() {
                                var currentDate = new Date();
                                var lastDayOfMonth = new Date(currentDate.getFullYear(), currentDate.getMonth() + 1, 0);
                                lastDayOfMonth.setHours(23, 59, 59, 999);
                                return Math.floor(lastDayOfMonth.getTime() / 1000);
                              }
                
                              function startFlipdown() {
                                var endOfMonthTimestamp = calculateEndOfMonthTimestamp();
                                console.log(endOfMonthTimestamp);
                
                                var flipdown = new FlipDown(endOfMonthTimestamp, 'flipdownTimer')
                                  .start()
                                  .ifEnded(() => {
                                    console.log('The countdown has ended!');
                                    // Recalculate the timestamp for the end of the next month when the countdown ends
                                    startFlipdown();
                                  });
                              }
                
                              startFlipdown();
                            });
                          </script>
                        </h6>
                      </div>
                    
                  </div>
                </div>
                
                <table class="table table-bordered text-nowrap table-no-vertical-border table-flush" id="example1">
                <thead class="thead-light">
                    <tr>
                        <th scope="col border-bottom-0">RANK</th>
                        <th scope="col border-bottom-0">ID</th>
                        <th scope="col border-bottom-0">USER NAME</th>
                        <th scope="col border-bottom-0">POST</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $top_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($key + 1); ?></td> <!-- Increment rank with each row -->
                                <td><?php echo e(user_code($data->user_id)); ?></td>
                                <td><?php echo e(find_user($data->user_id)->name); ?></td>
                                <td><?php echo e($data->total); ?> <small>Post</small></td>
                            </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
                
            </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('backend/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
    <script src="https://powerworkerearn.com/assets/js/flipdown.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.countdown/2.2.0/jquery.countdown.min.js" integrity="sha512-lteuRD+aUENrZPTXWFRPTBcDDxIGWe5uu0apPEn+3ZKYDwDaEErIK9rvR0QzUGmUQ55KFE2RqGTVoZsKctGMVw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

    <script>
        $(function() {
            $("#example1").DataTable({
                "responsive": true,
                "autoWidth": false,
            });
            $('#example2').DataTable({
                "paging": true,
                "lengthChange": false,
                "searching": false,
                "ordering": true,
                "info": true,
                "autoWidth": false,
                "responsive": true,
            });
        });

        function deleteData(id) {
            if (confirm("Are you sure?")) {
                document.getElementById('delete-form-'+id).submit();
            }
            return false;
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/powerwor/public_html/resources/views/backend/pages/system-setting/top-job-poster-headline.blade.php ENDPATH**/ ?>